import paho.mqtt.client as mqtt
import json

def on_connect(client, userdata, flags, rc):
    if rc == 0:
        print("Connected")
        client.subscribe("balluff//iolink/devices/master1port8/processdata/in")
    else:
        print("Failed to connect, Error code", rc)

def on_message(client, userdata, msg):
    payload = json.loads(msg.payload.decode())
    item = payload.get("data", {}).get("items", {})

    print(item)

client = mqtt.Client()
client.on_connect = on_connect
client.on_message = on_message
client.connect("192.168.10.200", 1883)
client.loop_forever()





